/*
 * Decompiled with CFR 0.152.
 */
package corgiaoc.byg.util.noise.worley;

import corgiaoc.byg.util.noise.worley.Noise;
import corgiaoc.byg.util.noise.worley.XorShift;
import java.util.Random;

public class WorleyNoise
extends Noise {
    private final XorShift randomFactory;

    public WorleyNoise(Random seed) {
        super(seed);
        this.randomFactory = XorShift.create(seed);
    }

    private static int floor(double n) {
        return n > 0.0 ? (int)n : (int)n - 1;
    }

    private static double frac(double n) {
        return n >= 0.0 ? n - (double)((int)n) : WorleyNoise.frac(-n);
    }

    private static double minimumDistance(XorShift.Instance r, Point origin) {
        double dnz2;
        double dpz2;
        double dnx2;
        double dpx2;
        Point p = new Point(origin.x + 1.0E-7, origin.z + 1.0E-7);
        int x = WorleyNoise.floor(p.x);
        int z = WorleyNoise.floor(p.z);
        double s = Double.MAX_VALUE;
        s = WorleyNoise.processVoxel(r, p, s, x, z);
        double d = dpx2 = p.x >= 0.0 ? WorleyNoise.square(1.0 - WorleyNoise.frac(p.x)) : WorleyNoise.square(WorleyNoise.frac(p.x));
        if (dpx2 < s) {
            s = WorleyNoise.processVoxel(r, p, s, x + 1, z);
        }
        double d2 = dnx2 = p.x >= 0.0 ? WorleyNoise.square(WorleyNoise.frac(p.x)) : WorleyNoise.square(1.0 - WorleyNoise.frac(p.x));
        if (dnx2 < s) {
            s = WorleyNoise.processVoxel(r, p, s, x - 1, z);
        }
        double d3 = dpz2 = p.z >= 0.0 ? WorleyNoise.square(1.0 - WorleyNoise.frac(p.z)) : WorleyNoise.square(WorleyNoise.frac(p.z));
        if (dpz2 < s) {
            s = WorleyNoise.processVoxel(r, p, s, x, z + 1);
        }
        double d4 = dnz2 = p.z >= 0.0 ? WorleyNoise.square(WorleyNoise.frac(p.z)) : WorleyNoise.square(1.0 - WorleyNoise.frac(p.z));
        if (dnz2 < s) {
            s = WorleyNoise.processVoxel(r, p, s, x, z - 1);
        }
        for (int i = -1; i <= 1; ++i) {
            for (int k = -1; k <= 1; ++k) {
                if (Noise.fastAbs(i) + Noise.fastAbs(k) <= 1) continue;
                double vd2 = 0.0;
                if (i < 0) {
                    vd2 += dnx2;
                } else if (i > 0) {
                    vd2 += dpx2;
                }
                if (k < 0) {
                    vd2 += dnz2;
                } else if (k > 0) {
                    vd2 += dpz2;
                }
                if (!(vd2 < s)) continue;
                s = WorleyNoise.processVoxel(r, p, s, x + i, z + k);
            }
        }
        return WorleyNoise.fastSqrt(s);
    }

    private static double processVoxel(XorShift.Instance r, Point p, double s, int x, int z) {
        r.setSeed(x, z);
        Point created = new Point((double)x + r.nextDouble(), (double)z + r.nextDouble());
        double distance = p.distanceSquared(created);
        return Math.min(distance, s);
    }

    private static double square(double n) {
        return n * n;
    }

    protected static double lerp(double progress, double start, double end) {
        return start + progress * (end - start);
    }

    private double noise(double x, double y, double z) {
        return WorleyNoise.minimumDistance(this.randomFactory.getInstance(), new Point(x, z));
    }

    @Override
    public double sample2D(double x, double z) {
        return this.noise(x, 0.0, z);
    }

    @Override
    public double sample3D(double x, double y, double z) {
        return this.noise(x, y, z);
    }

    private static final class Point {
        private final double x;
        private final double z;

        private Point(double x, double z) {
            this.x = x;
            this.z = z;
        }

        public double distanceSquared(Point other) {
            double x2 = this.x - other.x;
            double z2 = this.z - other.z;
            return x2 * x2 + z2 * z2;
        }
    }
}

